<?php
// api/get_user_data.php
include '../config.php';
include '../auth_check.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN'] ?? '*');
header('Access-Control-Allow-Credentials: true');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Método no permitido']);
    exit();
}

$database = new Database();
$db = $database->getConnection();

try {
    $query = "SELECT 
                nombre,
                email,
                telefono,
                saldo,
                rating,
                total_viajes,
                total_contactos,
                tipo,
                estado,
                ultima_conexion
              FROM usuarios 
              WHERE id = :user_id AND estado = 'activo'";
    
    $stmt = $db->prepare($query);
    $stmt->bindParam(':user_id', $_SESSION['user_id']);
    $stmt->execute();
    
    if ($stmt->rowCount() === 1) {
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Formatear datos
        $user['saldo'] = floatval($user['saldo']);
        $user['rating'] = floatval($user['rating']);
        $user['total_viajes'] = intval($user['total_viajes']);
        $user['total_contactos'] = intval($user['total_contactos']);
        
        echo json_encode([
            'success' => true,
            'user' => $user
        ]);
    } else {
        http_response_code(404);
        echo json_encode([
            'success' => false,
            'error' => 'Usuario no encontrado'
        ]);
    }
    
} catch (PDOException $e) {
    error_log("API User Data error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Error interno del servidor'
    ]);
}
?>