<?php
// logout.php
include 'config.php';

// Registrar logout
if (isset($_SESSION['user_id'])) {
    error_log("User " . $_SESSION['user_id'] . " logged out");
}

// Destruir todas las variables de sesión
$_SESSION = array();

// Destruir cookie de sesión
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Destruir la sesión
session_destroy();

// Redirigir al login con mensaje
header("Location: auth/login.php?logout=1");
exit();
?>